﻿#pragma   once

#include  "BitmapManager.hpp"

class CMenuHandlerBase
{
protected:
  CMenuHandlerBase();
  virtual ~CMenuHandlerBase();

  HRESULT InitializeImpl(__in PCIDLIST_ABSOLUTE pidlFolder, __in IDataObject *pdtobj, __in HKEY hkeyProgID);
  void InsertItem(HMENU hmenu, UINT index, UINT uID, const szchar *text, int nIconID);
  HRESULT MenuMessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT *pResult);

  virtual UINT MenuIdToIconID(UINT uID) = 0; // should return ~0 if not found

  bool                  m_HasFile; // ファイルが（少なくとも一つは）選択されているかどうか。本当はこのクラスで保持するのは不適切だが、共通化できるのでしちゃった。
  szstring              m_DirPath;
  szstring              m_ArchiveStem;
  std::vector<szstring> m_Files;
  BitmapManager         m_BitmapManager;
};
